/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.config;

import com.stal111.valhelsia_structures.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.config.StructureGenConfig;
import com.stal111.valhelsia_structures.init.ModStructures;
import com.stal111.valhelsia_structures.world.structures.AbstractValhelsiaStructure;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.util.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;

public class ConfigValidator
extends AbstractConfigValidator {
    public void validate() {
        for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
            AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
            StructureConfigEntry configEntry = structure.getStructureConfigEntry();
            if ((Integer)configEntry.configuredSpacing.get() - (Integer)configEntry.configuredSeparation.get() <= 0) {
                this.addError((IFormattableTextComponent)new TranslationTextComponent("gui.valhelsia_structures.config.spacing_error"), "structures." + structure.getName() + ".spacing", (IFormattableTextComponent)new TranslationTextComponent("gui.valhelsia_structures.config.spacing_solution", new Object[]{(Integer)configEntry.configuredSeparation.get() + 1}));
            }
            for (String string : (List)configEntry.configuredBiomeCategories.get()) {
                if (!Arrays.stream(Biome.Category.values()).noneMatch(category -> category.func_222352_a().equals(string))) continue;
                this.addError(new TranslationTextComponent("gui.valhelsia_structures.config.invalid_biome_category").func_240702_b_(" " + string), "structures." + structure.getName() + ".biome_categories", (IFormattableTextComponent)new TranslationTextComponent("gui.valhelsia_core.config.ignoring"));
            }
            for (String biome : (List)configEntry.configuredBlacklistedBiomes.get()) {
                if (biome.contains("*") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
                this.addError(new TranslationTextComponent("gui.valhelsia_structures.config.invalid_blacklisted_biome").func_240702_b_(" " + biome), "structures." + structure.getName() + ".blacklisted_biomes", (IFormattableTextComponent)new TranslationTextComponent("gui.valhelsia_core.config.ignoring"));
            }
        }
        for (String biome : (List)StructureGenConfig.BLACKLISTED_BIOMES.get()) {
            if (biome.contains("*") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
            this.addError(new TranslationTextComponent("gui.valhelsia_structures.config.invalid_blacklisted_biome").func_240702_b_(" " + biome), "structures.global.blacklisted_biomes", (IFormattableTextComponent)new TranslationTextComponent("gui.valhelsia_core.config.ignoring"));
        }
    }
}

